/*
 * COMP 15 (F99) Programming Assignment 6
 *    Simple guessing game
 *    Your name:   
 */
import java.io.*;
public class Main
{
	
	/**************************************************************
	 * main program - execution starts here                       *
	 **************************************************************/
	public static void main(String[] args)
	{
		// introduce game
		printIntro();
		
		// play successive games until user quits
		playGames();
		
		// report statistics
		printStatistics();
		
		// wait to end
		prompt("Thanks for playing.  Enter any number to close this window:  ");
	}
	
	
	
	/**************************************************************
	 * class variables                                            *
	 **************************************************************/
	private static int max      = 100;          // pick values between 1 and max
	private static BufferedReader bufStdInput;  // access to keyboard input stream
	
	
	
    /**************************************************************
	 * private class methods                                      *
	 **************************************************************/
	
	/*
	 * printIntro():  introduce game
	 */
	private static void printIntro()
	{
	    System.out.println("Welcome to the guessing game.\n");
		System.out.print("I will choose a number between 1 and " + max);
		System.out.println(" ... and you try to guess it.\n");
		System.out.println("With each guess, I will tell you whether you are high or low.");
		System.out.println("The objective is to find the number using as few guesses as possible.\n");
		System.out.println("Let's start!\n\n");

	}
	
	
	/*
	 * playGames():  repeatedly play game, keeping track of number of 
	 *   games played and total number of guesses in completed games.
	 */
	private static void playGames()
	{
		// TODO: construct this method and any additional methods it might use.
	}
	
	
	/*
	 * printStatistics(): show number of games completed and average number of
	 *                    guesses per game.
	 */
	private static void printStatistics()
	{
		// TODO: construct this method
	}
	
	
    /*
	 * prompt(s):  print string s and request an integer input from keyboard
	 *   returns integer entered, or 
	 *   returns 0 if an unrecoverable error occurs
	 */
	private static int prompt(String s)
	{		
		// initialize input stream on initial use
		if (bufStdInput == null)
		{
			bufStdInput = new BufferedReader(new InputStreamReader(System.in));
		}
		
		// prompt for input
		System.out.print(s);
		System.out.flush();
		
		// read input line
		while (true){
			try {
				return Integer.parseInt(bufStdInput.readLine().trim());
			}
			catch (NumberFormatException e1) {
				System.out.print("*** You should supply a number.  Try again:  ");
			}
			catch (IOException e2) {
				System.out.println("Unexpected I/O exception " + e2);
				return 0;
			}	
		}
	}
}
