//Linear Ratboost[Q,A,E] and AdaBoost[R,SS], ICML 2019 released code
// Note: SS = Schapire + Singer's AdaBoost

import java.io.*;
import java.util.*;


class Experiments implements Debuggable{
    
    public static String KEY_HELP = "--help", KEY_RESOURCE = "-R";
    
    Algorithm myAlgos;
    Domain myDomain;

    public static String help(){
	String ret = "";
	ret += KEY_HELP + " : example command line\n\n";
	ret += KEY_RESOURCE + " :: name of resource file to parse algorithms\n";

	return ret;
    }

    public static void main(String [] arg){
	int i;
	String kR = "";
	for (i=0;i<arg.length;i++){
	    if (arg[i].equals(KEY_HELP)){
		Dataset.perror(help());
	    }

	    if (arg[i].equals(KEY_RESOURCE))
		kR = arg[i+1];
	}
	
	if (kR.equals(new String("")))
	    Dataset.perror("No resource file name found in command line");

	System.out.println("\n\n/////////////////////////////////////////////////////////////////////////////////////////////");
	System.out.println("// This is the code for the paper \"Lossless or Quantized Boosting with Integer Arithmetic\" //");
	System.out.println("// by R. Nock and R.-C. Williamson, published at ICML 2019 (Long Beach, CA)                //");
	System.out.println("// -- THIS CODE IS PROVIDED WITH NO GUARANTEE WHATSOEVER: USE IT AT YOUR OWN RISKS         //");
	System.out.println("// -- Feedback at: richard.nock@data61.csiro.au; consult the README                        //");
	System.out.println("/////////////////////////////////////////////////////////////////////////////////////////////\n\n");
	
	if (SAVE_MEMORY)
	    System.out.println("** Saving memory for processing");
	System.out.print("** Parsing resource file " + kR + " ...");

	Experiments ee = new Experiments();
	ee.go(kR);
    }

    public void go(String rs){
	Vector v;
	parse(rs);
	v = myAlgos.go();
	myAlgos.save(v);
	myAlgos.save_test_errs();
	myAlgos.save_test_errs_iter_stop();

	myDomain.myMemoryMonitor.stop();
    }
    
    public void parse(String rs){
	FileReader e;
	BufferedReader br;
	StringTokenizer t;
	String dum, n, nameD = "", nameP = "";
	Vector v;

	myDomain = null;

	// Domain
	try{
	    e = new FileReader(rs);
	    br = new BufferedReader(e);
	    
	    while ( (dum=br.readLine()) != null){
		if ( (dum.length() == 1) || ( (dum.length()>1) && (!dum.substring(0,Dataset.KEY_COMMENT.length()).equals(Dataset.KEY_COMMENT)) ) ){
		    t = new StringTokenizer(dum,Dataset.KEY_SEPARATION_STRING[Dataset.SEPARATION_INDEX]); 
		    n = t.nextToken();
		    if (n.equals(Dataset.KEY_DIRECTORY))
			nameD = t.nextToken();
		    else if (n.equals(Dataset.KEY_PREFIX))
			nameP = t.nextToken();
		    else if  (n.equals(Dataset.KEY_WARNING_LONG))
			Rational_Number.WARNING_LONG = Long.parseLong(t.nextToken());
		    else if  (n.equals(Dataset.KEY_EPSILON_DELTA))
			Rational_Number.EPSILON_DELTA_DEN = Integer.parseInt(t.nextToken());
		    else if  (n.equals(Dataset.KEY_EPSILON_OPERATOR))
			Rational_Number.EPSILON_OPERATOR_DEN = Integer.parseInt(t.nextToken());		
		}
	    }
	    e.close();
	}catch(IOException eee){
	    System.out.println("Problem loading ." + rs + " resource file --- Check the access to file");
	    System.exit(0);
	}

	if (nameD.equals(new String("")))
	    Dataset.perror("No domain in resource file");
	if (nameP.equals(new String("")))
	    Dataset.perror("No prefix in resource file");

	System.out.println("\n\nDomain * " + nameP + " * in directory * " + nameD + " *\n");

	Rational_Number.Init_Frac();
	
	myDomain = new Domain(nameD, nameP);
	myAlgos = new Algorithm(myDomain);

	// Algos
	try{
	    e = new FileReader(rs); 
	    br = new BufferedReader(e);
	    
	    while ( (dum=br.readLine()) != null){
		if ( (dum.length() == 1) || ( (dum.length()>1) && (!dum.substring(0,Dataset.KEY_COMMENT.length()).equals(Dataset.KEY_COMMENT)) ) ){
		    t = new StringTokenizer(dum,Dataset.KEY_SEPARATION_STRING[Dataset.SEPARATION_INDEX]); 
		    n = t.nextToken();
		    if (n.equals(Dataset.KEY_ALGORITHM)){
			v = new Vector();
			while(t.hasMoreTokens())
			    v.addElement(new String(t.nextToken()));
			myAlgos.addAlgorithm(v);
		    }
		}
	    }
	    e.close();
	}catch(IOException eee){
	    System.out.println("Problem loading ." + rs + " resource file --- Check the access to file");
	    System.exit(0);
	}
    }

}
