//Linear Ratboost[Q,A,E] and AdaBoost[R,SS], ICML 2019 released code

import java.util.*;
import java.io.*;

public class LinearBoost implements Debuggable{
    public static int QUANTIZE_TOT, ITER_TOT;
    
    public static String [] METHOD_WEIGHTS_STRING = {"AdaBoost.R", "Real Adaboost (S.S.)", "Rational-arith", "Quantized-Rat", "Quantized-Rat-Adaptive", "Rat-EXACT"};    
    public static String [] METHOD_NAMES = {"@AdaBoost_R", "@AdaBoostSS", "@RatioBoost", "@RatBoost_Q", "@RatBoost_A", "@RatBoost_E"};
    public static String [] METHOD_NAME_SAVE = {"adaboostR", "adaboostSS", "ratboost", "ratboostQ", "ratboostA", "ratboostE"};

    public static double MAX_ABS_MU = 0.99999;
    // prevents overflows with AdaBoost(R, SS) for the computation of the leveraging coefficient (1.0 -> |alpha| = infty) + weight update for AdaBoostSS (1.0 -> weight update overflows)

    public static int ITER_STOP;

    Domain myDomain;
    
    int split_number;

    double [] theta;

    // everything labeled EXACT refers to the implementation of RatBoostE
    Rational_Number [] theta_EXACT;

    double [] weights;
    double [] q_weights; 
    // array of quantized weights value in increasing order for @RatBoost.Q
    // updated for @RatBoost.A

    Rational_Number [] weights_EXACT;
    Rational_Number [] q_weights_EXACT;
    Rational_Number [] q_delta_EXACT;
    Rational_Number max_h_delta, max_h_operator;

    double xstarstar;
    double [] star;
    double [] sqr_expect;
    
    int methodWeights, nIterMax, nRows; 

    double [] average_err, average_perr, average_perr_squared;
    // average error (empirical) and test error (test) as a function of T, averaged over all folds

    double average_iter_stop;

    boolean stochastic_quant;
    
    public boolean IS_AdaBoost_R(int n){
	if (n == 0)
	    return true;
	return false;
    }

    public boolean IS_AdaBoostSS(int n){
	if (n == 1)
	    return true;
	return false;
    }

    public boolean IS_RatioBoost(int n){
	if (n == 2)
	    return true;
	return false;
    }

    public boolean IS_RatBoost_Q(int n){
	if (n == 3)
	    return true;
	return false;
    }

    public boolean IS_RatBoost_A(int n){
	if (n == 4)
	    return true;
	return false;
    }

    public boolean IS_RatBoost_E(int n){
	if (n == 5)
	    return true;
	return false;
    }

    public static int INDEX_METHOD_NAMES(String s){
	int i;
	for (i=0;i<METHOD_NAMES.length;i++)
	    if (s.equals(METHOD_NAMES[i]))
		return i;
	Dataset.perror("Value " + s + " for algorithm not recognized");
	return -1;
    }

    public static boolean IS_QUANTIZED(String s){
	if ( (INDEX_METHOD_NAMES(s) == 3) || (INDEX_METHOD_NAMES(s) == 4) || (INDEX_METHOD_NAMES(s) == 5) )
	    return true;
	return false;
    }

    public static double H(double x){
	if (x < 0.0)
	    return -x;
	return 0.0;
    }

    public static double err(double w){
	if (w < 0.5)
	    return w;
	else
	    return 1.0 - w;
    }

    LinearBoost(Domain dom, String algo_name, int nIter){
	myDomain = dom;
	nIterMax = nIter;
	methodWeights = LinearBoost.INDEX_METHOD_NAMES(algo_name); //nWeight;
	
	nRows = -1;
	weights =null;
	average_err = average_perr = average_perr_squared = null;
    }

    LinearBoost(Domain dom, String algo_name, int nIter, int quanti, int stochast){
	this (dom, algo_name, nIter);

	if ( (quanti % 2 == 0) || (quanti < 3) )
	    Dataset.perror("LinearBoost.class :: Quantizer int " + quanti + " must be odd >= 3");

	if ( (stochast != 0) && (stochast != 1) )
	    Dataset.perror("LinearBoost.class :: Stochastic quantization parameter " + stochast + " must be in {0, 1}");

	if (stochast == 0)
	    stochastic_quant = false;
	else
	    stochastic_quant = true;
	
	q_weights = new double [quanti]; 
	int i;
	q_weights[0] = LinearBoost.EPS3;//(1.0 / (double) (2 * quanti));
	q_weights[quanti-1] = 1.0 - q_weights[0];

       	for (i=1;i<quanti-1;i++)
	    q_weights[i] = ((double) i / (double) (quanti-1));

	if (IS_RatBoost_E(methodWeights)){
	    LinearBoost.QUANTIZE_TOT = 0;
	    LinearBoost.ITER_TOT = 0;
	    
	    q_weights_EXACT = new Rational_Number[quanti];
	    q_weights_EXACT[0] = new Rational_Number(0, quanti);
	    for (i=1;i<quanti;i++)
		q_weights_EXACT[i] = new Rational_Number(q_weights_EXACT[i-1].num + 1, quanti);
	}
    }

    public String fullName(){
	String ret = LinearBoost.METHOD_NAMES[methodWeights];
	if ( (IS_RatBoost_Q(methodWeights)) || (IS_RatBoost_A(methodWeights)) )
	    ret += "[" + q_weights.length + "] [" + stochastic_quant + "]";
	else if (IS_RatBoost_E(methodWeights))
	    ret += "[" + q_weights.length + "]";
	ret += " - Iter = " + nIterMax + ", nRowsLearning = " + nRows;
	return ret;
    }

    public String fullNameSave(){
	String ret = LinearBoost.METHOD_NAME_SAVE[methodWeights];
	if ( (IS_RatBoost_Q(methodWeights)) || (IS_RatBoost_A(methodWeights))  || (IS_RatBoost_E(methodWeights)) )
	    ret += "_" + q_weights.length + "_" + stochastic_quant;
	return ret;
    }

    // display methods

    public String theta(){
	String val = "";
	int i;
	val += ("Theta = ");
	for (i=0;i<theta.length;i++)
	    val += (DF.format(theta[i]) + " ");
	return val;
    }

    // Boosting algorithms

    public void initRound(int split){
	theta = new double [myDomain.myDS.number_real_features];
	star = new double [myDomain.myDS.number_real_features];
	sqr_expect = new double [myDomain.myDS.number_real_features];

	System.out.print(" * " + METHOD_NAMES[methodWeights]);
	if ( (IS_RatBoost_Q(methodWeights)) || (IS_RatBoost_A(methodWeights)) )
	    System.out.print("[" + q_weights.length + "][" + stochastic_quant + "]");
	else if (IS_RatBoost_E(methodWeights))
	    System.out.print("[" + q_weights.length + "]");
	    
	System.out.print(" > Starting fold " + (split+1) + "/" + NUMBER_STRATIFIED_CV + " -- ");

	split_number = split;	
	nRows = myDomain.myDS.train_size(split_number);

	int i, ne = myDomain.myDS.train_size(split_number), nr;
	for (i=0;i<theta.length;i++){
	    theta[i] = 0.0;
	}

	weights = new double [ne];
	for (i=0;i<ne;i++){
	    if (IS_RatioBoost(methodWeights) || IS_RatBoost_Q(methodWeights) || IS_RatBoost_A(methodWeights))
		weights[i] = 0.5;
	    else
		weights[i] = 1.0 / ((double) ne);
	}

	xstarstar = -1.0;
	for (i=0;i<theta.length;i++){
	    star[i] = myDomain.myDS.xstar(split_number, i);
	    sqr_expect[i] = myDomain.myDS.sqr_expect(split_number, i);
	    if ( (i==0) || (xstarstar < star[i]) )
		xstarstar = star[i];
	}

	Example ee;
	if (IS_RatBoost_E(methodWeights)){
	    weights_EXACT = new Rational_Number [ne];
	    for (i=0;i<ne;i++){
		weights_EXACT[i] = new Rational_Number(1,2);
	    }
	    
	    theta_EXACT = new Rational_Number [myDomain.myDS.number_real_features];
	    for (i=0;i<theta.length;i++)
		theta_EXACT[i] = new Rational_Number();

	    max_h_delta = Rational_Number.Smallest_Rational_Number(xstarstar, Rational_Number.EPSILON_DELTA);
	    max_h_operator = Rational_Number.Smallest_Rational_Number(xstarstar, Rational_Number.EPSILON_OPERATOR);

	    System.out.print("(Creating rational ops");
	    for (i=0;i<ne;i++){
		ee = myDomain.myDS.train_example(split_number, i);
		ee.complete_rational_operator(max_h_operator);
		if ( i % (ne / 10) == 0 )
		    System.out.print(".");
	    }
	    System.out.print(" ok.) ");
	}
    }

    public Vector boost(){
	int i;
	Vector cur, res = new Vector();
	double [] nT = new double [nIterMax];
	//records, for each index in average_*, how many values are to be averaged;
	double dit, dval;
	double average_stop = 0.0;

	average_err = new double[nIterMax];
	average_perr = new double[nIterMax];
	average_perr_squared = new double[nIterMax];
	
	for (i=0;i<nIterMax;i++){
	    nT[i] = 0.0;
	    average_err[i] = 0.0;
	    average_perr[i] = 0.0;
	    average_perr_squared[i] = 0.0;
	}

	for (i=0;i<NUMBER_STRATIFIED_CV;i++){
	    initRound(i);

	    LinearBoost.ITER_STOP = -1;
	    cur = iterate(nT);
	    if (LinearBoost.ITER_STOP == -1)
		Dataset.perror("LinearBoost.class :: LinearBoost.ITER_STOP = -1");

	    average_stop += (double) LinearBoost.ITER_STOP;

	    res.addElement(cur);
	}
	average_stop /= (double) NUMBER_STRATIFIED_CV;
	average_iter_stop = average_stop;

	for (i=0;i<nIterMax;i++){
	    dit = nT[i];
	    if (dit > 0.0){
		dval = average_err[i];
		dval /= dit;
		average_err[i] = dval;

		dval = average_perr[i];
		dval /= dit;
		average_perr[i] = dval;

		dval = average_perr_squared[i];
		dval /= dit;
		average_perr_squared[i] = dval;
	    }else{
		dval = average_err[i];
		if (dval > 0.0)
		    Dataset.perror("number of iterations = 0 but err = " + dval);
		average_err[i] = -1.0;

		dval = average_perr[i];
		if (dval > 0.0)
		    Dataset.perror("number of iterations = 0 but perr = " + dval);
		average_perr[i] = -1.0;

		dval = average_perr_squared[i];
		if (dval > 0.0)
		    Dataset.perror("number of iterations = 0 but perr_squared = " + dval);
		average_perr_squared[i] = -1.0;
	    }
	}

	System.out.println("");

	if (SAVE_MEMORY)
	    theta = star = weights = null;

	return res;
    }

    public Vector iterate(double [] nT){
	Vector ret = new Vector();
	// 0. Tmax
	// 1. besti
	// 2. err_emp_init
	// 3. min_err_emp
	// 4. get_err_test
	// 5. l2
	// 6. supporteps

	int i, j, besti = -1, Tmax = 0;
	double err_emp, min_err_emp = -1.0, err_test, get_err_test = -1.0, l2, supporteps, dval, err_emp_init;
	double [] bestTheta = null;
	boolean improvement;

	err_emp_init = error(true);

	for (i=0;i<nIterMax;i++){

	    if (IS_RatBoost_E(methodWeights))
		improvement = one_iteration_EXACT(i);
	    else
		improvement = one_iteration();

	    err_emp = error(true);
	    err_test = error(false);

	    if ( (i==0) || (err_emp <= min_err_emp) ){
		bestTheta = Utils.copyOf(theta);
		min_err_emp = err_emp;
		get_err_test = err_test;
		besti = i;
		LinearBoost.ITER_STOP = i;
	    }

	    nT[i] = nT[i] + 1.0;
	    average_err[i] = average_err[i] + err_emp;
	    average_perr[i] = average_perr[i] + err_test;
	    average_perr_squared[i] = average_perr_squared[i] + (err_test * err_test);

	    if (i%(nIterMax/5) == 0){
		System.out.print( ((i/(nIterMax/5)) * 20) + "% ");
		if (Domain.SAVE_MEMORY)
		    System.out.print(myDomain.memString() + " ");
	    }

	    Tmax = (i+1);

	    if (!Algorithm.STOP_IF_NO_IMPROVEMENT)
		improvement = true;

	    if (!improvement)
	    	i = nIterMax;
	}

	l2 = Utils.L2(bestTheta);
	supporteps = Utils.supportEPS(bestTheta);

	System.out.println("ok. \t(perr err l2 sup) = (" + DF.format(min_err_emp) + " " + DF.format(get_err_test) + " " + DF.format(l2) + " " + DF.format(supporteps) + ")");

	ret.addElement(new Double(Tmax));
	ret.addElement(new Double((double) besti));
	ret.addElement(new Double(err_emp_init * 100.0));
	ret.addElement(new Double(min_err_emp * 100.0));
	ret.addElement(new Double(get_err_test * 100.0));
	ret.addElement(new Double(l2));
	ret.addElement(new Double(supporteps * 100.0));

	return ret;
    }

    public int wfi(){
	//implements Weak Feature Index oracle
	int i, iret = -1;
	double cur, mx = 0.0, curmu;
	for (i=0;i<myDomain.dimOperator;i++){
	    curmu = muBoost(i,false);
	    cur = Math.abs(curmu);

	    if ( (i==0) || (cur > mx) ){
		iret = i;
		mx = cur;
	    }
	}

	return iret;
    }

    public double muBoost(int nf, boolean normalize){
	// computes edge mu using operators
	// if normalize = false, does not normalize (for picking WFI)
	
	int index;
	double sum = 0.0, vv, sig;
	for (index=0;index<nRows;index++){
	    vv = (weights[index] * getOperator(index)[nf]);
	    sum += vv;
	}

	if ( (normalize) && ((IS_AdaBoost_R(methodWeights)) || (IS_AdaBoostSS(methodWeights))) ){
	    sum /= star[nf];
	    if (Math.abs(sum) > 1.0)
		Dataset.perror("Mu = " + sum + " > 1.0");
	    if (Math.abs(sum) > LinearBoost.MAX_ABS_MU)
		sum = Math.signum(sum) * LinearBoost.MAX_ABS_MU;
	}

	return sum;
    }

    public boolean one_iteration(){
	// return true iff weights change, i.e. significant difference with update
	boolean sig;
	int nf = wfi();
	double mu = muBoost(nf, true);
	double alpha = alpha(mu, nf);

	theta[nf] += alpha;

	sig = reweightAll(mu, nf, alpha);
	return sig;
    }

    
    public double alpha(double mu, int nf){
	if ( IS_RatioBoost(methodWeights) || IS_RatBoost_Q(methodWeights) || IS_RatBoost_A(methodWeights) )
	    return alphaRatBoost(mu, nRows, nf);
	return alphaBoost(mu, nf);
    }

    public double alphaRatBoost(double mu, int siz, int nf){
	double valexp = (2.0 / (sqr_expect[nf] * sqr_expect[nf])) * (mu / (double) siz); // "exact" upperbound on M, estimated from training
	return valexp;
    }

    public double alphaBoost(double mu, int nf){
	double val = 0.0;
	double num = 1.0 + mu, den = 1.0 - mu;
	val = Math.log(num/den);
	val /= (2.0 * star[nf]);

	return val;
    }

    public boolean reweightAll(double mu, int nf, double alp){
	if (IS_RatioBoost(methodWeights))
	    return reweightAll_RatioBoost(nf, alp);
	else if (IS_RatBoost_Q(methodWeights))
	    return reweightAll_RatBoost_Q(nf, alp);
	else if (IS_RatBoost_A(methodWeights))
	    return reweightAll_RatBoost_A(nf, alp);
	else if (IS_AdaBoostSS(methodWeights))
	    return reweightAll_AdaBoostSS(nf, alp);
	else if (IS_AdaBoost_R(methodWeights))
	    return reweightAll_AdaBoostR(mu, nf, alp);
	else
	    Dataset.perror("No weighting method for " + methodWeights);
	return false;
    }

    public boolean normalizeWeights(double sumsum){
	// normalizes and returns true iff one weight is leading

	int index;
	double w, diff, maxw = -1.0;

	if (sumsum < EPS)
	    Dataset.perror("sum of weights is approximately zero (" + sumsum + ")");

	for (index=0;index<nRows;index++){
	    w = weights[index];
	    w /= sumsum;
	    weights[index] = w;

	    if ( (index == 0) || (w > maxw) )
		maxw = w;
	}

	// double check

	if (!SAVE_TIME){
	    double sum = 0.0;
	    for (index=0;index<nRows;index++)
	    sum += weights[index];
	    
	    diff = Math.abs(1.0 - sum);
	    if (diff > EPS)
		Dataset.perror("LinearBoost :: sum of weights " + sum + " != 1.0");
	}

	if (maxw > 1.0 - EPS)
	    return true;
	return false;
    }

    public boolean reweightAll_RatBoost_A(int nf, double delt){
	int index, i, opt_index;
	double op, w, diff, xx, num, den, disc, opt_disc;
	boolean improvement;
	double [] dum_w = new double [weights.length];
	double [] q_dum_w = new double [q_weights.length];

	// Step 1: compute eventual new weights
	dum_w = new double [weights.length];
	for (index=0;index<nRows;index++){
	    dum_w [index] = weights[index];
	    w = dum_w[index];

	    if ( (w == 0.0) || (w == 1.0) )
		Dataset.perror("LinearBoost.class :: weight = " + w);
	    op = getOperator(index)[nf];
	    xx = (delt * op) + ((1.0 - 2.0 * w) / LinearBoost.err(w));
	    num = 1.0 + LinearBoost.H(xx);
	    den = 2.0 + Math.abs(xx);
	    w = num / den;
	    dum_w [index] = w;
	}
	// Step 2: clustering weights
	KMeans_R km = new KMeans_R(dum_w, q_weights.length);
	km.run_k_means();

	// Step 3: assigns new weights from clustering
	for (index=0;index<nRows;index++)
	    weights[index] = km.centroids[km.cluster_index[index]];

	improvement = (Math.abs(delt) > EPS2);
	return improvement;
    }

    public boolean reweightAll_RatBoost_Q(int nf, double delt){
	int index, i, opt_index, iu, iv;
	double op, w, diff, xx, num, den, disc, opt_disc, optw, wu, wv, wz;
	boolean improvement;

	for (index=0;index<nRows;index++){
	    w = weights[index];

	    if ( (w == 0.0) || (w == 1.0) )
		Dataset.perror("LinearBoost.class :: weight = " + w);
	    op = getOperator(index)[nf];
	    xx = (delt * op) + ((1.0 - 2.0 * w) / LinearBoost.err(w));
	    num = 1.0 + LinearBoost.H(xx);
	    den = 2.0 + Math.abs(xx);
	    w = num / den;

	    i=0;
	    wu = q_weights[0];
	    wv = q_weights[1];
	    wz = q_weights[q_weights.length - 1];
	    if (w <= wu)
		weights[index] = wu;
	    else if (w >= wz)
		weights[index] = wz;
	    else{
		while( ( (w < wu) || (w > wv) ) && (i<q_weights.length-2) ){
		    i++;
		    wu = q_weights[i];
		    wv = q_weights[i+1];
		}
		if ( (w < wu) || (w > wv) ) 
		    Dataset.perror("LinearBoost.class :: quantization error as for i = " + i + " we do not have w = " + w + " in [" + wu + ", " + wv + "]");
		
		weights[index] = Utils.Quantize(wu, wv, Math.abs(w - wu), Math.abs(w - wv), stochastic_quant);
	    }
	}
	improvement = (Math.abs(delt) > EPS2);

	return improvement;
    }
    
    public boolean reweightAll_RatioBoost(int nf, double delt){
	int index, i;
	double op, w, diff, xx, num, den;
	boolean improvement;

	for (index=0;index<nRows;index++){
	    w = weights[index];
	    if ( (w > 0.0) && (w < 1.0) ){
		op = getOperator(index)[nf];
		xx = (delt * op) + ((1.0 - 2.0 * w) / LinearBoost.err(w));
		num = 1.0 + LinearBoost.H(xx);
		den = 2.0 + Math.abs(xx);
		w = num / den;
	    }
	    if ( (w < 0.0) || (w > 1.0) )
		Dataset.perror("Weight " + w + " should be in [0,1]");
	    weights[index] = w;
	}
	improvement = (Math.abs(delt) > EPS2);

	return improvement;
    }

    public boolean reweightAll_AdaBoostSS(int nf, double alp){
	int index, i;
	double op, w, sum = 0.0, diff;
	boolean improvement, oneweight;

	for (index=0;index<nRows;index++){
	    w = weights[index];
	    op = getOperator(index)[nf];
	    w = (w * Math.exp(- alp * op));
	    weights[index] = w;

	    sum += w;
	}
	oneweight = normalizeWeights(sum);
	improvement = (Math.abs(alp) > EPS2);

	return improvement;
    }

    public boolean reweightAll_AdaBoostR(double mu, int nf, double alp){
	double lastw, neww, den, num, op, diffc, maxd = 0.0, w, sum = 0.0;
	int index, i;
	boolean improvement, oneweight;

	den = 1.0 - (mu * mu);

	for (index=0;index<nRows;index++){
	    lastw = weights[index];
	    w = lastw;
	    if (lastw <= 0.0)
		Dataset.perror("LinearBoost :: weights " + w + " < 0.0");
	    op = getOperator(index)[nf];
	    num = 1.0 - ( (mu * op) / star[nf]);
	    w = w * (num / den);
	    neww = w;

	    diffc = Math.abs(lastw - neww);
	    if ( (index == 0) || (diffc > maxd) )
		maxd = diffc;
	    
	    weights[index] = w;

	    sum += w;
	}

	oneweight = normalizeWeights(sum);
	improvement = (maxd > 0.0);

	if (Math.abs(alp) < EPS2)
	    improvement = false;

	if (oneweight)
	  improvement = false;
	
	return improvement;
    }

    // BOOSTING MISC FUNCTIONS

    public double[] getOperator(int index){
	return myDomain.myDS.train_example(split_number, index).operator;
    }

    public Rational_Number [] getRationalOperator(int index){
	return myDomain.myDS.train_example(split_number, index).rational_operator;
    }

    //Computes the error

    public double error(boolean onTraining){
	Example ee;
	double sumerr = 0.0;
	boolean rc;
	int i, ne;
	if (onTraining)
	    ne = myDomain.myDS.train_size(split_number);
	else
	    ne = myDomain.myDS.test_size(split_number);

	for (i=0;i<ne;i++){
	    if (onTraining)
		ee = myDomain.myDS.train_example(split_number, i);
	    else
		ee = myDomain.myDS.test_example(split_number, i);
	    rc = ee.rightClass(theta);
	    if (!rc)
		sumerr += 1.0;
	}
	sumerr /= (double) ne;

	return sumerr;
    }

    // METHODS related to RatBoostE

    public Rational_Number alphaRatBoost_EXACT(int nf){
	// computes edge mu using operators + exact rational arithmetics
	int index;
	Rational_Number res = new Rational_Number();
	Rational_Number mul = new Rational_Number(2, nRows);
	Rational_Number dum, op;
	
	for (index=0;index<nRows;index++){
	    op = getRationalOperator(index)[nf];
	    dum = new Rational_Number(weights_EXACT[index]);
	    dum.timesReduce(op);
	    res.addReduce(dum);
	}
	res.timesReduce(mul);

	if (Rational_Number.Warning_OverFlow(res)){
	    Rational_Number.quantize_feature_EXACT(res, Rational_Number.EPSILON_DELTA);
	}
	
	return res;
    }


   public void test_alphaRatBoost_EXACT(int nf) throws java.lang.ArithmeticException{
       //just makes the test that alpha can be computed without overflow
	int index;
	Rational_Number res = new Rational_Number();
	Rational_Number mul = new Rational_Number(2, nRows);
	Rational_Number dum, op;
	
	for (index=0;index<nRows;index++){
	    op = getRationalOperator(index)[nf];
	    dum = new Rational_Number(weights_EXACT[index]);
	    dum.timesReduce(op);
	    res.addReduce(dum);
	}
	res.timesReduce(mul);
   }
    
    public boolean one_iteration_EXACT(int iter){
	// return true iff weights change, i.e. significant difference with update
	boolean sig = true;
	int nf = wfi(); 

	try{
	    test_alphaRatBoost_EXACT(nf);
	}catch (java.lang.ArithmeticException eo){
	    LinearBoost.QUANTIZE_TOT += 1;
	    quantize_EXACT();
	}
	LinearBoost.ITER_TOT += 1;
	
	Rational_Number alpha = alphaRatBoost_EXACT(nf);

	theta_EXACT[nf].addReduce(alpha);
	if (Rational_Number.Warning_OverFlow(theta_EXACT[nf])){
	    Rational_Number.quantize_feature_EXACT(theta_EXACT[nf], Rational_Number.EPSILON_DELTA);
	}
	
	theta[nf] = theta_EXACT[nf].toDouble();

	try{
	    test_reweightAll_EXACT(nf, alpha);
	}catch (java.lang.ArithmeticException eo){
	    Dataset.warning("LinearBoost.class :: overflow in weight size update -- quantizing weights");
	    quantize_EXACT();
	}
	
	try{
	    sig = reweightAll_EXACT(nf, alpha);
	}catch (java.lang.ArithmeticException eo){
	    Dataset.perror("LinearBoost.class :: overflow in weight size -- should not happen !!!");
	}
	
	return sig;
    }
    

    public void quantize_EXACT(){
	int index, i, opt_index;
	long dep;
	Rational_Number w, mm = null, MM = null, val, tv;
	double ref, dm, dM;
	
	for (index=0;index<nRows;index++){
	    w = weights_EXACT[index];
	    if (w.isOutsideBounds())
		Dataset.perror("LinearBoost.class :: rational weight = " + w);
	    dep = Math.round( (w.toDouble()) * ( (double) q_weights_EXACT[0].den ) ); 
	    val = new Rational_Number(dep, q_weights_EXACT[0].den);
	    
	    if ( (dep <= 0) || (dep >= q_weights_EXACT[0].den) )
		Dataset.perror("LinearBoost.class :: weight " + w.toDouble() + " outside bounds from fraction " + (new Rational_Number(dep, q_weights_EXACT[0].den)));
	    
	    ref = ((double) dep / (double) q_weights_EXACT[0].den);
	    tv = new Rational_Number();
	    
	    if (ref == w.toDouble())
		tv.copyFrom(val);
	    else{
		if (ref < w.toDouble()){
		    mm = new Rational_Number(dep, q_weights_EXACT[0].den);
		    MM = new Rational_Number(dep + 1, q_weights_EXACT[0].den);
		}else{
		    mm = new Rational_Number(dep - 1, q_weights_EXACT[0].den);
		    MM = new Rational_Number(dep, q_weights_EXACT[0].den);
		}
		Rational_Number.CheckIn(w, mm, MM);
		dm = Math.abs(val.toDouble() - mm.toDouble());
		dM = Math.abs(val.toDouble() - MM.toDouble());

		if (dm <= dM)
		    tv.copyFrom(mm);
		else
		    tv.copyFrom(MM);
	    }	    
	    weights_EXACT[index].copyFrom(tv);
	}
    }
    
    public boolean warning_EXACT(){
	int index;
	for (index=0;index<nRows;index++)
	    if (Rational_Number.Warning_OverFlow(weights_EXACT[index]))
		return true;
	return false;
    }
    
    public void test_reweightAll_EXACT(int nf, Rational_Number delt) throws java.lang.ArithmeticException{
	//just makes the test that all weights can be updated without overflow
		int index, i;
	boolean improvement;
	
	Rational_Number w, z, op;
	long a, b, c, d, newnum = 0, newden = 0;
	for (index=0;index<nRows;index++){
	    w = weights_EXACT[index];
	    if ( (w.num == 0) || (w.num >= w.den) )
		Dataset.perror("Fraction " + w + " should be in [0,1]");
	    z = new Rational_Number(delt);
	    op = getRationalOperator(index)[nf];
	    z.timesReduce(op);

	    a = Math.multiplyExact((Math.min(w.num, Math.subtractExact(w.den, w.num))), z.den);
	    b = Math.multiplyExact((Math.min(w.num, Math.subtractExact(w.den, w.num))), z.num);
	    c = Math.multiplyExact(w.den, z.den);
	    d = Math.multiplyExact(2,Math.multiplyExact(Math.subtractExact(w.den,Math.multiplyExact(2,w.num)), z.den));

	    if (b + (d/2) > 0){
		newnum = a;
		newden = Math.addExact(b, Math.subtractExact(c, Utils.hinge(d)));
	    }else if (b + (d/2) < 0){
		newnum = Math.addExact(-b, Math.subtractExact(c, Math.addExact(Utils.hinge(-d), a)));
		newden = Math.addExact(-b, Math.subtractExact(c, Utils.hinge(-d)));
	    }else{
		newnum = 1;
		newden = 2;
	    }
	}
    }

    public boolean reweightAll_EXACT(int nf, Rational_Number delt) throws java.lang.ArithmeticException{
	// see paper, Lemma 6
	
	int index, i;
	boolean improvement;
	
	Rational_Number w, z, op;
	long a, b, c, d, newnum = 0, newden = 0;
	for (index=0;index<nRows;index++){
	    w = weights_EXACT[index];
	    if ( (w.num == 0) || (w.num >= w.den) )
		Dataset.perror("Fraction " + w + " should be in [0,1]");
	    z = new Rational_Number(delt);
	    op = getRationalOperator(index)[nf];
	    z.timesReduce(op);

	    a = Math.multiplyExact((Math.min(w.num, Math.subtractExact(w.den, w.num))), z.den);
	    b = Math.multiplyExact((Math.min(w.num, Math.subtractExact(w.den, w.num))), z.num);
	    c = Math.multiplyExact(w.den, z.den);
	    d = Math.multiplyExact(2,Math.multiplyExact(Math.subtractExact(w.den,Math.multiplyExact(2,w.num)), z.den));

	    if (b + (d/2) > 0){
		newnum = a;
		newden = Math.addExact(b, Math.subtractExact(c, Utils.hinge(d)));
	    }else if (b + (d/2) < 0){
		newnum = Math.addExact(-b, Math.subtractExact(c, Math.addExact(Utils.hinge(-d), a)));
		newden = Math.addExact(-b, Math.subtractExact(c, Utils.hinge(-d)));
	    }else{
		newnum = 1;
		newden = 2;
	    }

	    if ( (newnum <= 0) && (newden <= 0) ){
		newnum = -newnum;
		newden = -newden;
	    }
	    
	    if ( (newnum <= 0) || (newden <= 0) )
		Dataset.perror("Fraction (" + newnum + "/" + newden + ") ineligible");

	    weights_EXACT[index] = new Rational_Number(newnum, newden);
	    weights_EXACT[index].reduce();
	    
	    weights[index] = weights_EXACT[index].toDouble();
	}
	
	improvement = (Math.abs((double) delt.num / (double) delt.den) > EPS2);

	return improvement;
    }
}
