//Linear Ratboost[Q,A,E] and AdaBoost[R,SS], ICML 2019 released code

import java.text.DecimalFormat;
import java.util.Random;

interface Debuggable {
    static DecimalFormat DF = new DecimalFormat("#0.0000");
    static DecimalFormat DF0 = new DecimalFormat("#0.00");

    static boolean Debug = false;

    //variables used to optimize a bit space + time
    static boolean SAVE_MEMORY = true;
    static boolean SAVE_TIME = true;

    static double EPS = 1E-4;
    static double EPS2 = 1E-6;
    static double EPS3 = 1E-10;

    public static int NUMBER_STRATIFIED_CV = 10;
}

/**************************************************************************************************************************************
 * Class KMeans
 * straightforward implementation of Kmeans with Forgy init. Replace it with your faster / optimal version of 1D KMeans...
 *****/
class KMeans_R implements Debuggable{
    
    int nc;
    double [] reals;
    int [] cluster_index;

    double [] centroids;

    KMeans_R(double [] r, int k){
	reals = new double [r.length];
	cluster_index = new int [r.length];

	nc = k;
	centroids = new double [nc];

	int i;
	for (i=0;i<reals.length;i++){
	    reals[i] = r[i];
	    cluster_index[i] = -1;
	}
    }

    public void run_k_means(){
	// to add: quicksort weights

	double distort_min = -1.0, distort = 0.0;
	int i = 0;
	boolean stop = false;

	init_k_meansForgy();
	do{
	    compute_cluster_index();
	    compute_centroids();
	    distort = potential();
	    if ( (i > 0) && (distort >= distort_min) )
		stop = true;
	    distort_min = distort;
	    i++;
	}while(!stop);
    }

    public double potential(){
	double val = 0.0;
	int i;
	for (i=0;i<reals.length;i++){
	    if (centroids[cluster_index[i]] < 0.0)
		Dataset.perror("KMeans_R.class :: potential :: centroid[" + cluster_index[i] + "] = " + centroids[cluster_index[i]] + " < 0.0");
	    val += distance(reals[i], centroids[cluster_index[i]]);
	}
	return val;
    }

    public double distance(double v, double w){
	return ( (v-w) * (v-w) );
    }

    public void compute_cluster_index(){
	int i, j, opt_index = -1;
	double dist = -1.0, opt_dist = -1;
	boolean first;

	for (i=0;i<reals.length;i++){
	    first = true;
	    for (j=0;j<nc;j++){
		if (centroids[j] >= 0.0){
		    dist = distance(reals[i],centroids[j]);
		    if (first || (dist < opt_dist)){
			opt_dist = dist;
			opt_index = j;
		    }
		    first = false;
		}
	    }
	    cluster_index[i] = opt_index;
	}

    }

    public void compute_centroids(){
	int i, j, k, ci, empty_cluster_index = -1;
	double val, size;
	boolean replace = true, one_empty = false;
	int [] empty_clusters = new int [nc];
	for (j=0;j<nc;j++)
	    empty_clusters[j] = -1;

	for (j=0;j<nc;j++){
	    if (centroids[j] != -1.0){
		val = 0.0;
		size = 0.0;
		for (i=0;i<reals.length;i++){
		    if (cluster_index[i] == j){
			val += reals[i];
			size += 1.0;
		    }
		}
		if (size == 0){
		    one_empty = true;
		    
		    empty_cluster_index++;
		    empty_clusters[empty_cluster_index] = j;
		}else{
		    val /= size;
		    centroids[j] = val;
		}
	    }
	}

	if (empty_cluster_index > -1){
	    // replace empty clusters centroids by -1.0
	    for (j=0;j<nc;j++)
		if (empty_clusters[j] > -1)
		    centroids[empty_clusters[j]] = -1.0;
	}
    }

    public boolean contains(int [] inds, int ind){
	int i = 0;
	do{
	    if (inds[i] == ind)
		return true;
	    i++;
	}while(i<inds.length);
	return false;
    }

    public boolean contains(double [] inds, double ind){
	int i = 0;
	do{
	    if (inds[i] == ind)
		return true;
	    i++;
	}while(i<inds.length);
	return false;
    }


    public int nb_different_values(double [] vals){
	int i, nb = 0;
	double [] vals2 = new double [vals.length];
	for (i=1;i<vals.length;i++)
	    vals2[i] = vals[i];

	QuickSort.quicksort(vals2);

	for (i=1;i<vals2.length-1;i++)
	    if (vals2[i] != vals2[i+1])
		nb++;
	return nb;
    }

    public void init_k_meansForgy(){
	int index = -1;
	int i, j, nbv;
	int [] index_chosen = new int [nc];
	double [] reals_chosen = new double [nc];
	double rv;

	Random r = new Random();
	boolean found;

	for (i=0;i<nc;i++){
	    index_chosen[i] = -1;
	    reals_chosen[i] = -1.0;
	}

	nbv = nb_different_values(reals);

	for (i=0;i<nc;i++){
	    do{
		index = Math.abs(r.nextInt())%cluster_index.length;
		rv = reals[index];

		found = false;
		if ( (contains(index_chosen, index)) || ( (nbv > nc) && (contains(reals_chosen, rv)) ) )
		    found = true;
	    }while (found);
	    index_chosen[i] = index;
	    reals_chosen[i] = rv;
	}
	for (i=0;i<nc;i++)
	    centroids[i] = reals[index_chosen[i]];
	for (i=0;i<nc;i++)
	    if (centroids[i] < 0.0)
		Dataset.perror("KMeans_R.class :: centroid[" + i + "] = " + centroids[i] + " < 0.0");
    }
}
