/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.launcher;

import androidx.test.tools.crawler.launcher.exceptions.ApkSigningException;
import androidx.test.tools.crawler.launcher.setup.CrawlSetup;
import com.android.apksig.ApkSigner;
import com.android.apksigner.PasswordRetriever;
import com.android.apksigner.SignerParams;
import com.google.common.flogger.GoogleLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;

public class ApkSigner {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final CrawlSetup crawlSetup;
    private final List<ApkSigner.SignerConfig> signerConfigs = new ArrayList<ApkSigner.SignerConfig>();

    public ApkSigner(CrawlSetup crawlSetup) {
        this.crawlSetup = crawlSetup;
    }

    private void initializeSignerConfigs() throws ApkSigningException {
        SignerParams signerParams = new SignerParams();
        signerParams.setKeystoreFile(this.crawlSetup.getKeyStorePath());
        signerParams.setKeystorePasswordSpec("pass:" + this.crawlSetup.getKeyStorePassword());
        try {
            signerParams.loadPrivateKeyAndCerts(new PasswordRetriever());
        }
        catch (Exception e) {
            throw new ApkSigningException("Failed to initialize signer config", e);
        }
        this.signerConfigs.add(new ApkSigner.SignerConfig.Builder("RoboLauncherSignerConfig", signerParams.getPrivateKey(), signerParams.getCerts()).build());
    }

    public Path sign(Path apkFilePath) throws ApkSigningException {
        ((GoogleLogger.Api)logger.atFine()).log("Starting sign actions for APK %s", apkFilePath.toAbsolutePath());
        Path alignedApkFilePath = this.zipalign(this.copyToOutputDirectory(apkFilePath));
        Path signedApkFilePath = this.crawlSetup.getOutputDirectoryPath().resolve("signed_" + alignedApkFilePath.getFileName());
        ((GoogleLogger.Api)logger.atFine()).log("Applying apksigner on %s", alignedApkFilePath.toAbsolutePath());
        if (this.signerConfigs.isEmpty()) {
            this.initializeSignerConfigs();
        }
        try {
            new ApkSigner.Builder(this.signerConfigs).setInputApk(new File(alignedApkFilePath.toAbsolutePath().toString())).setOutputApk(new File(signedApkFilePath.toAbsolutePath().toString())).build().sign();
        }
        catch (Exception e) {
            throw new ApkSigningException("Failed to apply apksigner on " + alignedApkFilePath.toAbsolutePath(), e);
        }
        return signedApkFilePath;
    }

    private Path zipalign(Path apkFilePath) throws ApkSigningException {
        Path alignedFilePath = this.crawlSetup.getOutputDirectoryPath().resolve("aligned_" + apkFilePath.getFileName());
        try {
            Files.deleteIfExists(alignedFilePath);
            File zipalignExecutable = this.crawlSetup.getExecutable(CrawlSetup.ExecutableType.ZIPALIGN);
            Process zipalign = Runtime.getRuntime().exec(new String[]{zipalignExecutable.getAbsolutePath(), "4", apkFilePath.toAbsolutePath().toString(), alignedFilePath.toAbsolutePath().toString()}, null, zipalignExecutable.getParentFile());
            ((GoogleLogger.Api)logger.atFine()).log("Performing zipalign on %s", apkFilePath.toAbsolutePath());
            try (BufferedReader errorStreamReader = new BufferedReader(new InputStreamReader(zipalign.getErrorStream(), StandardCharsets.UTF_8));){
                while (errorStreamReader.readLine() != null) {
                }
            }
            zipalign.waitFor();
        }
        catch (Exception e) {
            throw new ApkSigningException("Failed to perform zipalign on " + apkFilePath.toAbsolutePath(), e);
        }
        return alignedFilePath;
    }

    private Path copyToOutputDirectory(Path apkFilePath) throws ApkSigningException {
        Path copyApkFilePath = this.crawlSetup.getOutputDirectoryPath().resolve("copied_" + apkFilePath.getFileName());
        try {
            Files.copy(apkFilePath, copyApkFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new ApkSigningException(String.format("Failed to copy APK %s to %s", apkFilePath.toAbsolutePath(), copyApkFilePath.toAbsolutePath()), e);
        }
        ((GoogleLogger.Api)logger.atFine()).log("Successfully copied APK %s to %s", (Object)apkFilePath.toAbsolutePath(), (Object)copyApkFilePath.toAbsolutePath());
        return copyApkFilePath;
    }
}

