/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.launcher;

import androidx.test.tools.crawler.common.base.Logger;
import androidx.test.tools.crawler.launcher.ApkSigner;
import androidx.test.tools.crawler.launcher.CrawlerRepacker;
import androidx.test.tools.crawler.launcher.LogcatRecorder;
import androidx.test.tools.crawler.launcher.VideocatRecorder;
import androidx.test.tools.crawler.launcher.exceptions.ApkSigningException;
import androidx.test.tools.crawler.launcher.exceptions.CrawlerRepackingException;
import androidx.test.tools.crawler.launcher.setup.CrawlSetup;
import androidx.test.tools.crawler.launcher.setup.CrawlSetupProvider;
import androidx.test.tools.crawler.launcher.util.AdbExecutor;
import androidx.test.tools.crawler.launcher.util.AppPackageNameExtractor;
import androidx.test.tools.crawler.launcher.util.FileUtil;
import androidx.test.tools.crawler.postprocessing.logcat.LogcatAnalyser;
import androidx.test.tools.crawler.postprocessing.logcat.LogcatFinding;
import androidx.test.tools.crawler.proto.CrawlOutputsProto;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.TextFormat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;

public class CrawlLauncher {
    private final CrawlSetup crawlSetup = CrawlSetupProvider.getCrawlSetup();
    private final AppPackageNameExtractor appPackageNameExtractor;
    private final ApkSigner apkSigner;
    private final CrawlerRepacker crawlerRepacker;
    private final AdbExecutor adbExecutor;
    private final int deviceApiLevel;

    public CrawlLauncher(String[] crawlParameters) {
        this.crawlSetup.processCrawlParameters(crawlParameters);
        this.appPackageNameExtractor = new AppPackageNameExtractor(this.crawlSetup);
        this.apkSigner = new ApkSigner(this.crawlSetup);
        this.crawlerRepacker = new CrawlerRepacker(this.crawlSetup, this.apkSigner);
        this.adbExecutor = new AdbExecutor(this.crawlSetup);
        this.deviceApiLevel = this.adbExecutor.getDeviceApiLevel();
    }

    public static void main(String[] args) throws CrawlerRepackingException, ApkSigningException {
        new CrawlLauncher(args).launchCrawl(false);
    }

    public CrawlSetup getCrawlSetup() {
        return this.crawlSetup;
    }

    public AdbExecutor getAdbExecutor() {
        return this.adbExecutor;
    }

    public void launchCrawl(boolean isHostGuidedCrawl) throws ApkSigningException, CrawlerRepackingException {
        String appPackageName = this.crawlSetup.getAppPackageName();
        if (appPackageName.isEmpty()) {
            appPackageName = this.appPackageNameExtractor.extractAppPackageName();
        }
        Logger.atInfo().log("Preparing to crawl %s", appPackageName);
        if (this.crawlSetup.isWakeDevice()) {
            this.adbExecutor.wakeDevice();
        }
        if (!isHostGuidedCrawl) {
            FileUtil.cleanupDirectory(this.crawlSetup.getOutputDirectoryPath());
        }
        this.crawlSetup.buildCrawler();
        Path signedRepackedCrawlerApkFilePath = this.crawlSetup.isUiAutomatorMode() || this.crawlSetup.isInstantAppsMode() ? this.crawlSetup.getCrawlerAppApkPath() : this.crawlerRepacker.repackAndSignCrawlerApp(appPackageName);
        Optional<Path> appApkFilePath = Optional.empty();
        if (!this.crawlSetup.getApkFilePath().isEmpty()) {
            appApkFilePath = Optional.of(Paths.get(this.crawlSetup.getApkFilePath(), new String[0]));
            if (!this.crawlSetup.isUiAutomatorMode() && !this.crawlSetup.isInstantAppsMode()) {
                appApkFilePath = Optional.of(this.apkSigner.sign(appApkFilePath.get()));
            }
        }
        this.installCrawlerAndApp(appPackageName, signedRepackedCrawlerApkFilePath, appApkFilePath);
        LogcatRecorder logcatRecorder = null;
        if (!isHostGuidedCrawl) {
            if (this.crawlSetup.isPauseBeforeCrawl()) {
                Logger.atInfo().log("Press Enter to start the crawl", new Object[0]);
                try {
                    System.in.read();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            logcatRecorder = new LogcatRecorder(this.adbExecutor, this.crawlSetup.getOutputDirectoryPath(), appPackageName);
            logcatRecorder.start();
            new VideocatRecorder(this.adbExecutor, this.crawlSetup, appPackageName, this.deviceApiLevel).start();
        }
        this.startCrawler(appPackageName);
        this.adbExecutor.stopReadingInput();
        if (!isHostGuidedCrawl) {
            this.processLogcat(logcatRecorder);
            this.processCrawlOutput();
        }
    }

    private void processLogcat(LogcatRecorder logcatRecorder) {
        try {
            Optional<LogcatFinding> crash;
            logcatRecorder.join();
            LogcatAnalyser analyser = new LogcatAnalyser();
            ImmutableList<LogcatFinding> logcatFindings = analyser.processLogcat(new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(logcatRecorder.getLogcat()), StandardCharsets.UTF_8)), false);
            long numOfNonSdkFindings = logcatFindings.stream().filter(finding -> finding.type() == LogcatFinding.LogcatFindingType.NON_SDK_API_USED).count();
            if (numOfNonSdkFindings > 0L) {
                Logger.atInfo().log("WARNING: Found %d usages of non-SDK API methods. See Logcat for details.", numOfNonSdkFindings);
            }
            if (!(crash = logcatFindings.stream().filter(f -> f.type() == LogcatFinding.LogcatFindingType.FATAL_EXCEPTION || f.type() == LogcatFinding.LogcatFindingType.NATIVE_CRASH).findAny()).isPresent()) {
                Logger.atInfo().log("SUCCESS: Found 0 crashes.", new Object[0]);
            } else {
                Logger.atInfo().log("FAILED: Found 1 crash.", new Object[0]);
                Logger.atInfo().log(crash.get().message(), new Object[0]);
                if (crash.get().stacktrace().isPresent()) {
                    Logger.atInfo().log(crash.get().stacktrace().get(), new Object[0]);
                }
            }
        }
        catch (IOException | InterruptedException e) {
            Logger.atWarning().withCause(e).log("Error while processing logcat.", new Object[0]);
        }
    }

    private void installCrawlerAndApp(String appPackageName, Path crawlerApkFilePath, Optional<Path> appApkFilePath) {
        this.cleanupDevice(appPackageName);
        boolean grantPermissionsOnInstall = this.deviceApiLevel >= 23;
        this.adbExecutor.installApp(grantPermissionsOnInstall, crawlerApkFilePath.toAbsolutePath().toString());
        this.adbExecutor.execute("shell", "pm", "grant", "androidx.test.tools.crawler", "android.permission.DUMP");
        this.adbExecutor.installApp(grantPermissionsOnInstall, "-r", this.crawlSetup.getCrawlerStubappApk().getAbsolutePath());
        if (appApkFilePath.isPresent()) {
            this.adbExecutor.installApp(grantPermissionsOnInstall, appApkFilePath.get().toAbsolutePath().toString());
        }
    }

    private void cleanupDevice(String appPackageName) {
        this.adbExecutor.execute("shell", "am", "force-stop", appPackageName);
        this.adbExecutor.execute("shell", "rm", "-rf", "/sdcard/app_firebase_test_lab");
        this.adbExecutor.execute("shell", "rm", "-rf", "/sdcard/robo_tmp_files");
        this.adbExecutor.uninstallApp("androidx.test.tools.crawler");
        if (!this.crawlSetup.getApkFilePath().isEmpty()) {
            this.adbExecutor.uninstallApp(appPackageName);
        }
    }

    private void startCrawler(String appPackageName) {
        List<String> executionOptions = this.getExecutionOptions(appPackageName);
        ArrayList<String> startServiceCommand = new ArrayList<String>(Arrays.asList("shell", "am", "startservice"));
        startServiceCommand.addAll(executionOptions);
        startServiceCommand.add("-n");
        startServiceCommand.add("androidx.test.tools.crawler/androidx.test.tools.crawler.controller.CrawlDriver");
        this.adbExecutor.execute(startServiceCommand);
        ArrayList<String> instrumentCommand = new ArrayList<String>(Arrays.asList("shell", "am", "instrument", "--no-window-animation", "-w", "-r"));
        instrumentCommand.addAll(executionOptions);
        CrawlLauncher.addExecutionOption("class", "androidx.test.tools.crawler.CrawlPlatform", instrumentCommand);
        instrumentCommand.add("androidx.test.tools.crawler/androidx.test.runner.AndroidJUnitRunner");
        Logger.atInfo().log("Crawl started.", new Object[0]);
        this.adbExecutor.execute(instrumentCommand);
        this.adbExecutor.execute("shell", "am", "instrument", "-w", "-r", "androidx.test.tools.crawler/.CrawlMonitor");
        Logger.atInfo().log("Crawl finished.", new Object[0]);
    }

    private List<String> getExecutionOptions(String appPackageName) {
        ArrayList<String> options = new ArrayList<String>();
        CrawlLauncher.addExecutionOption("crawlDurationSec", String.valueOf(this.crawlSetup.getCrawlTimeoutSeconds()), options);
        CrawlLauncher.addExecutionOption("appPackageName", appPackageName, options);
        CrawlLauncher.addExecutionOption("appListener", "androidx.test.tools.crawler.SignaturePatchingCallback", options);
        CrawlLauncher.addExecutionOption("disableAnalytics", "true", options);
        CrawlLauncher.addExecutionOption("executionId", UUID.randomUUID().toString(), options);
        CrawlLauncher.addExecutionOption("dataDir", this.crawlSetup.getOutputDirectoryPath().toAbsolutePath().toString(), options);
        if (this.crawlSetup.isTestAccessibility()) {
            CrawlLauncher.addExecutionOption("testAccessibility", "true", options);
        }
        if (this.crawlSetup.isInstantAppsMode()) {
            CrawlLauncher.addExecutionOption("instantAppsMode", "true", options);
        }
        CrawlLauncher.addExecutionOption("crawlDriverDaggerInitializerClassName", this.crawlSetup.getCrawlDriverInitializerClass(), options);
        Properties experiments = this.crawlSetup.getExperiments();
        for (String experimentName : experiments.stringPropertyNames()) {
            CrawlLauncher.addExecutionOption(experimentName, experiments.getProperty(experimentName), options);
        }
        return options;
    }

    private static void addExecutionOption(String optionName, String optionValue, List<String> options) {
        options.add("-e");
        options.add(optionName);
        options.add(optionValue);
    }

    private void processCrawlOutput() {
        this.adbExecutor.execute("pull", "/sdcard/app_firebase_test_lab", this.crawlSetup.getOutputDirectoryPath().toAbsolutePath().toString());
        Optional<File> crawlOutputsBinaryProtoFile = this.getCrawlOutputsBinaryProtoFile();
        if (crawlOutputsBinaryProtoFile.isPresent()) {
            Logger.atInfo().log("Converting output files", new Object[0]);
            try {
                CrawlOutputsProto.CrawlOutputs crawlOutputs = CrawlOutputsProto.CrawlOutputs.parseFrom(new FileInputStream(crawlOutputsBinaryProtoFile.get()));
                try (BufferedWriter fileWriter = Files.newBufferedWriter(Paths.get(this.crawlSetup.getCrawlOutputsTextProtoPath(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
                    TextFormat.print(crawlOutputs, (Appendable)fileWriter);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to convert output files", e);
            }
        }
        Logger.atInfo().log("The output directory is %s", this.crawlSetup.getOutputDirectoryPath().toAbsolutePath().toString());
    }

    private Optional<File> getCrawlOutputsBinaryProtoFile() {
        File crawlOutputsBinaryProtoFile = new File(this.crawlSetup.getCrawlOutputsBinaryProtoPath());
        for (int waitForCrawlOutputsAttempts = 30; !crawlOutputsBinaryProtoFile.exists() && waitForCrawlOutputsAttempts > 0; --waitForCrawlOutputsAttempts) {
            Logger.atDebug().log("Waiting for crawl outputs proto file %s", crawlOutputsBinaryProtoFile);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Logger.atWarning().log("Interrupted while waiting for outputs proto file %s", crawlOutputsBinaryProtoFile);
            }
        }
        if (!crawlOutputsBinaryProtoFile.exists()) {
            Logger.atWarning().log("Timed out waiting for crawl outputs proto file %s", crawlOutputsBinaryProtoFile);
            return Optional.empty();
        }
        return Optional.of(crawlOutputsBinaryProtoFile);
    }
}

