/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.launcher;

import androidx.test.tools.crawler.launcher.ApkSigner;
import androidx.test.tools.crawler.launcher.exceptions.ApkSigningException;
import androidx.test.tools.crawler.launcher.exceptions.CrawlerRepackingException;
import androidx.test.tools.crawler.launcher.setup.CrawlSetup;
import androidx.test.tools.crawler.launcher.util.FileUtil;
import com.google.common.flogger.GoogleLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;

public class CrawlerRepacker {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final CrawlSetup crawlSetup;
    private final ApkSigner apkSigner;

    public CrawlerRepacker(CrawlSetup crawlSetup, ApkSigner apkSigner) {
        this.crawlSetup = crawlSetup;
        this.apkSigner = apkSigner;
    }

    public Path repackAndSignCrawlerApp(String targetPackageName) throws ApkSigningException, CrawlerRepackingException {
        ((GoogleLogger.Api)logger.atFine()).log("Starting repack actions for APK %s", this.crawlSetup.getCrawlerAppApkPath().toAbsolutePath());
        Path repackedCrawlerPath = this.crawlSetup.getOutputDirectoryPath().resolve("repacked_" + this.crawlSetup.getCrawlerAppApkPath().getFileName());
        Path unpackedDirectoryPath = this.crawlSetup.getOutputDirectoryPath().resolve("unpacked");
        try {
            FileUtil.cleanupDirectory(unpackedDirectoryPath);
            this.unpackCrawlerApp(unpackedDirectoryPath);
            this.prepareUnpackedCrawlerForPacking(targetPackageName, unpackedDirectoryPath);
            this.packCrawlerApp(repackedCrawlerPath, unpackedDirectoryPath);
        }
        catch (Exception e) {
            throw new CrawlerRepackingException("Failed to repack the crawler app", e, targetPackageName, this.crawlSetup.getSignaturesFilePath(), this.crawlSetup.getCrawlGuidanceFilePath(), this.crawlSetup.getRoboScriptFilePath());
        }
        return this.apkSigner.sign(repackedCrawlerPath);
    }

    private void unpackCrawlerApp(Path outputPath) {
        ((GoogleLogger.Api)logger.atFine()).log("Unpacking the crawler app");
        try (FileSystem fileSystem = FileSystems.newFileSystem(this.crawlSetup.getCrawlerAppApkPath(), null);){
            Files.walkFileTree(fileSystem.getPath("/", new String[0]), new FileExtractor(outputPath));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unpack the crawler app", e);
        }
    }

    private void prepareUnpackedCrawlerForPacking(String targetPackageName, Path unpackedDirectoryPath) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("Preparing the unpacked crawler app for packing");
        Files.delete(unpackedDirectoryPath.resolve("AndroidManifest.xml"));
        Files.delete(unpackedDirectoryPath.resolve("resources.arsc"));
        FileUtil.deleteRecursively(unpackedDirectoryPath.resolve("res"));
        if (this.crawlSetup.getSignaturesFilePath().isPresent()) {
            Files.copy(this.crawlSetup.getSignaturesFilePath().get(), unpackedDirectoryPath.resolve("assets/signatures.txt"), new CopyOption[0]);
        }
        if (this.crawlSetup.getCrawlGuidanceFilePath().isPresent()) {
            Files.copy(this.crawlSetup.getCrawlGuidanceFilePath().get(), unpackedDirectoryPath.resolve("assets/guide.proto"), new CopyOption[0]);
        }
        if (this.crawlSetup.getRoboScriptFilePath().isPresent()) {
            Files.copy(this.crawlSetup.getRoboScriptFilePath().get(), unpackedDirectoryPath.resolve("assets/robo.script"), new CopyOption[0]);
        }
        Path newAndroidManifestPath = CrawlerRepacker.getNewAndroidManifestPath(unpackedDirectoryPath);
        ArrayList<String> newLines = new ArrayList<String>();
        for (String line : Files.readAllLines(newAndroidManifestPath)) {
            newLines.add(line.replace("android:targetPackage=\"${PLACEHOLDER}\"", "android:targetPackage=\"" + targetPackageName + "\""));
        }
        Files.write(newAndroidManifestPath, newLines, new OpenOption[0]);
    }

    private void packCrawlerApp(Path repackedCrawlerPath, Path unpackedDirectoryPath) throws IOException, InterruptedException {
        File aaptExecutable = this.crawlSetup.getExecutable(CrawlSetup.ExecutableType.AAPT);
        Path rawResources = CrawlerRepacker.getNewResPath(unpackedDirectoryPath);
        Path compiledResources = repackedCrawlerPath.resolveSibling("compiled_resources.zip");
        Process compiling = Runtime.getRuntime().exec(new String[]{aaptExecutable.getAbsolutePath(), "compile", "--dir", rawResources.toAbsolutePath().toString(), "-o", compiledResources.toAbsolutePath().toString()}, null, aaptExecutable.getParentFile());
        ((GoogleLogger.Api)logger.atFine()).log("Compiling resources %s", rawResources.toAbsolutePath());
        compiling.waitFor();
        Process linking = Runtime.getRuntime().exec(new String[]{aaptExecutable.getAbsolutePath(), "link", compiledResources.toAbsolutePath().toString(), "-I", this.crawlSetup.getAndroidJarPath(), "--manifest", CrawlerRepacker.getNewAndroidManifestPath(unpackedDirectoryPath).toAbsolutePath().toString(), "-o", repackedCrawlerPath.toAbsolutePath().toString()}, null, aaptExecutable.getParentFile());
        ((GoogleLogger.Api)logger.atFine()).log("Linking APK %s", repackedCrawlerPath.toAbsolutePath());
        linking.waitFor();
        try (FileSystem apkFileSystem = FileSystems.newFileSystem(repackedCrawlerPath, null);){
            Files.walkFileTree(unpackedDirectoryPath, new FileCompressor(apkFileSystem.getPath("/", new String[0]), unpackedDirectoryPath.toAbsolutePath().toString().length()));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to carry over the original crawler APK content", e);
        }
    }

    private static Path getNewAndroidManifestPath(Path unpackedDirectoryPath) {
        return unpackedDirectoryPath.resolve("assets/AndroidManifest.xml");
    }

    private static Path getNewResPath(Path unpackedDirectoryPath) {
        return unpackedDirectoryPath.resolve("assets/res");
    }

    private static class FileCompressor
    implements FileVisitor<Path> {
        private final Path outputPath;
        private final int inputPathPrefixLength;

        FileCompressor(Path outputPath, int inputPathPrefixLength) {
            this.outputPath = outputPath;
            this.inputPathPrefixLength = inputPathPrefixLength;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            String dirRelativePath = dir.toAbsolutePath().toString().substring(this.inputPathPrefixLength);
            if (!dirRelativePath.isEmpty()) {
                Files.createDirectories(this.outputPath.resolve(dirRelativePath), new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String fileRelativePath = file.toAbsolutePath().toString().substring(this.inputPathPrefixLength);
            Files.copy(file, this.outputPath.resolve(fileRelativePath), new CopyOption[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            ((GoogleLogger.Api)logger.atWarning()).log("Failed visiting file %s", file.toAbsolutePath());
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }

    private static class FileExtractor
    implements FileVisitor<Path> {
        private final String outputPath;

        FileExtractor(Path outputPath) {
            this.outputPath = outputPath.toAbsolutePath().toString();
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Files.createDirectories(Paths.get(this.outputPath + dir, new String[0]), new FileAttribute[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, Paths.get(this.outputPath + file, new String[0]), new CopyOption[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            ((GoogleLogger.Api)logger.atWarning()).log("Failed visiting file %s", file.toAbsolutePath());
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

