/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.launcher.util;

import androidx.test.tools.crawler.common.base.Logger;
import androidx.test.tools.crawler.launcher.exceptions.AdbExecutionException;
import androidx.test.tools.crawler.launcher.setup.CrawlSetup;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class AdbExecutor {
    private final CrawlSetup crawlSetup;
    private String deviceSerialCode = "";
    private volatile boolean stopReadingInput = false;

    public AdbExecutor(CrawlSetup crawlSetup) {
        this.crawlSetup = crawlSetup;
        this.deviceSerialCode = this.getDeviceSerialCode(crawlSetup.getDeviceNameRegex(), crawlSetup.getDeviceSerialCode());
    }

    public void stopReadingInput() {
        this.stopReadingInput = true;
    }

    public int getDeviceApiLevel() {
        String apiLevel = new String(this.execute("shell", "getprop", "ro.build.version.sdk"), StandardCharsets.UTF_8);
        if (!apiLevel.isEmpty()) {
            try {
                return Integer.parseInt(apiLevel.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new AdbExecutionException("Failed to detect device API level. Make sure there is a connected device or emulator. If more than one device/emulator are running, use '--device-name' or '--device-serial-code' to specify the device/emulator you wish to run on.");
    }

    public void wakeDevice() {
        this.execute("shell", "input", "keyevent", "26");
    }

    public void installApp(boolean grantPermissionsOnInstall, String ... args) {
        ArrayList<String> commandArgs = new ArrayList<String>(Arrays.asList(args));
        if (grantPermissionsOnInstall) {
            commandArgs.add(0, "-g");
        }
        commandArgs.add(0, "install");
        this.execute(commandArgs);
    }

    public void uninstallApp(String appPackageName) {
        this.execute("uninstall", appPackageName);
    }

    public byte[] execute(String ... args) {
        return this.execute(new ArrayList<String>(Arrays.asList(args)));
    }

    public byte[] execute(List<String> args) {
        String adbCommand = args.get(0);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int readBytes;
            File adbExecutable = this.crawlSetup.getExecutable(CrawlSetup.ExecutableType.ADB);
            if (!this.deviceSerialCode.isEmpty()) {
                args.add(0, this.deviceSerialCode);
                args.add(0, "-s");
            }
            args.add(0, adbExecutable.getAbsolutePath());
            Process command = Runtime.getRuntime().exec(args.toArray(new String[0]), null, adbExecutable.getParentFile());
            Logger.atDebug().log("Executing adb command %s", AdbExecutor.convertAdbCommandArgsToString(args));
            byte[] buffer = new byte[10240];
            try (InputStream inputStream = command.getInputStream();){
                while ((readBytes = inputStream.read(buffer)) != -1 && !this.stopReadingInput) {
                    out.write(buffer, 0, readBytes);
                }
            }
            if (!"logcat".equals(adbCommand)) {
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                try (InputStream errorStream = command.getErrorStream();){
                    while ((readBytes = errorStream.read(buffer)) != -1 && !this.stopReadingInput) {
                        err.write(buffer, 0, readBytes);
                    }
                }
                for (String errorLine : new String(err.toByteArray(), StandardCharsets.UTF_8).split("\n", -1)) {
                    if (!errorLine.startsWith("error:")) continue;
                    throw new AdbExecutionException(errorLine);
                }
            }
            if (!this.stopReadingInput) {
                command.waitFor();
            }
        }
        catch (Exception e) {
            throw new AdbExecutionException("Failed to execute adb command " + AdbExecutor.convertAdbCommandArgsToString(args), e);
        }
        return out.toByteArray();
    }

    private String getDeviceSerialCode(String deviceNameRegex, String userSpecifiedSerialCode) {
        Pattern devicePattern = Pattern.compile("device:" + deviceNameRegex);
        ArrayList<String> serialCodes = new ArrayList<String>();
        for (String device : new String(this.execute("devices", "-l"), StandardCharsets.UTF_8).split("\n", -1)) {
            if (!devicePattern.matcher(device).find()) continue;
            serialCodes.add(device.trim().substring(0, device.trim().indexOf(" ")));
        }
        if (!deviceNameRegex.isEmpty()) {
            if (serialCodes.isEmpty()) {
                throw new AdbExecutionException("Could not find an attached device that matches name regex " + deviceNameRegex);
            }
            if (serialCodes.size() > 1) {
                throw new AdbExecutionException("Multiple devices match device name regex " + deviceNameRegex);
            }
            return (String)serialCodes.get(0);
        }
        if (!userSpecifiedSerialCode.isEmpty()) {
            if (serialCodes.contains(userSpecifiedSerialCode)) {
                return userSpecifiedSerialCode;
            }
            throw new AdbExecutionException("No devices/emulators with serial code " + userSpecifiedSerialCode + " found");
        }
        if (serialCodes.isEmpty()) {
            throw new AdbExecutionException("No devices/emulators found");
        }
        if (serialCodes.size() > 1) {
            throw new AdbExecutionException("More than one device/emulator found. Use '--device-name' or '--device-serial-code' option to pick a specific device/emulator.");
        }
        return "";
    }

    private static String convertAdbCommandArgsToString(List<String> adbCommandArgs) {
        StringBuilder stringArgs = new StringBuilder();
        for (int i = 1; i < adbCommandArgs.size(); ++i) {
            stringArgs.append(adbCommandArgs.get(i)).append(" ");
        }
        return "\"" + stringArgs.toString().trim() + "\"";
    }
}

