/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.postprocessing.logcat;

import androidx.test.tools.crawler.postprocessing.logcat.LogLine;
import com.google.common.base.Optional;
import org.joda.time.Duration;
import org.joda.time.Instant;

final class AutoValue_LogLine
extends LogLine {
    private final LogLine.LogMessageType type;
    private final Instant timeStamp;
    private final LogLine.LogSeverity severity;
    private final String tag;
    private final int processId;
    private final int lineNumber;
    private final String message;
    private final String fullLogLine;
    private final Optional<String> sourceClass;
    private final Optional<String> sourceMethod;
    private final Optional<String> sourceLine;
    private final Optional<String> causedBy;
    private final Optional<String> packageName;
    private final Optional<Integer> targetProcessId;
    private final Optional<Duration> startupTime;
    private final Optional<String> nonSdkApiSignature;

    private AutoValue_LogLine(LogLine.LogMessageType type, Instant timeStamp, LogLine.LogSeverity severity, String tag, int processId, int lineNumber, String message, String fullLogLine, Optional<String> sourceClass, Optional<String> sourceMethod, Optional<String> sourceLine, Optional<String> causedBy, Optional<String> packageName, Optional<Integer> targetProcessId, Optional<Duration> startupTime, Optional<String> nonSdkApiSignature) {
        this.type = type;
        this.timeStamp = timeStamp;
        this.severity = severity;
        this.tag = tag;
        this.processId = processId;
        this.lineNumber = lineNumber;
        this.message = message;
        this.fullLogLine = fullLogLine;
        this.sourceClass = sourceClass;
        this.sourceMethod = sourceMethod;
        this.sourceLine = sourceLine;
        this.causedBy = causedBy;
        this.packageName = packageName;
        this.targetProcessId = targetProcessId;
        this.startupTime = startupTime;
        this.nonSdkApiSignature = nonSdkApiSignature;
    }

    @Override
    public LogLine.LogMessageType type() {
        return this.type;
    }

    @Override
    public Instant timeStamp() {
        return this.timeStamp;
    }

    @Override
    public LogLine.LogSeverity severity() {
        return this.severity;
    }

    @Override
    public String tag() {
        return this.tag;
    }

    @Override
    public int processId() {
        return this.processId;
    }

    @Override
    public int lineNumber() {
        return this.lineNumber;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public String fullLogLine() {
        return this.fullLogLine;
    }

    @Override
    public Optional<String> sourceClass() {
        return this.sourceClass;
    }

    @Override
    public Optional<String> sourceMethod() {
        return this.sourceMethod;
    }

    @Override
    public Optional<String> sourceLine() {
        return this.sourceLine;
    }

    @Override
    public Optional<String> causedBy() {
        return this.causedBy;
    }

    @Override
    public Optional<String> packageName() {
        return this.packageName;
    }

    @Override
    public Optional<Integer> targetProcessId() {
        return this.targetProcessId;
    }

    @Override
    public Optional<Duration> startupTime() {
        return this.startupTime;
    }

    @Override
    public Optional<String> nonSdkApiSignature() {
        return this.nonSdkApiSignature;
    }

    public String toString() {
        return "LogLine{type=" + (Object)((Object)this.type) + ", timeStamp=" + this.timeStamp + ", severity=" + (Object)((Object)this.severity) + ", tag=" + this.tag + ", processId=" + this.processId + ", lineNumber=" + this.lineNumber + ", message=" + this.message + ", fullLogLine=" + this.fullLogLine + ", sourceClass=" + this.sourceClass + ", sourceMethod=" + this.sourceMethod + ", sourceLine=" + this.sourceLine + ", causedBy=" + this.causedBy + ", packageName=" + this.packageName + ", targetProcessId=" + this.targetProcessId + ", startupTime=" + this.startupTime + ", nonSdkApiSignature=" + this.nonSdkApiSignature + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LogLine) {
            LogLine that = (LogLine)o;
            return this.type.equals((Object)that.type()) && this.timeStamp.equals(that.timeStamp()) && this.severity.equals((Object)that.severity()) && this.tag.equals(that.tag()) && this.processId == that.processId() && this.lineNumber == that.lineNumber() && this.message.equals(that.message()) && this.fullLogLine.equals(that.fullLogLine()) && this.sourceClass.equals(that.sourceClass()) && this.sourceMethod.equals(that.sourceMethod()) && this.sourceLine.equals(that.sourceLine()) && this.causedBy.equals(that.causedBy()) && this.packageName.equals(that.packageName()) && this.targetProcessId.equals(that.targetProcessId()) && this.startupTime.equals(that.startupTime()) && this.nonSdkApiSignature.equals(that.nonSdkApiSignature());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.type.hashCode();
        h *= 1000003;
        h ^= this.timeStamp.hashCode();
        h *= 1000003;
        h ^= this.severity.hashCode();
        h *= 1000003;
        h ^= this.tag.hashCode();
        h *= 1000003;
        h ^= this.processId;
        h *= 1000003;
        h ^= this.lineNumber;
        h *= 1000003;
        h ^= this.message.hashCode();
        h *= 1000003;
        h ^= this.fullLogLine.hashCode();
        h *= 1000003;
        h ^= this.sourceClass.hashCode();
        h *= 1000003;
        h ^= this.sourceMethod.hashCode();
        h *= 1000003;
        h ^= this.sourceLine.hashCode();
        h *= 1000003;
        h ^= this.causedBy.hashCode();
        h *= 1000003;
        h ^= this.packageName.hashCode();
        h *= 1000003;
        h ^= this.targetProcessId.hashCode();
        h *= 1000003;
        h ^= this.startupTime.hashCode();
        h *= 1000003;
        return h ^= this.nonSdkApiSignature.hashCode();
    }

    static final class Builder
    extends LogLine.Builder {
        private LogLine.LogMessageType type;
        private Instant timeStamp;
        private LogLine.LogSeverity severity;
        private String tag;
        private Integer processId;
        private Integer lineNumber;
        private String message;
        private String fullLogLine;
        private Optional<String> sourceClass = Optional.absent();
        private Optional<String> sourceMethod = Optional.absent();
        private Optional<String> sourceLine = Optional.absent();
        private Optional<String> causedBy = Optional.absent();
        private Optional<String> packageName = Optional.absent();
        private Optional<Integer> targetProcessId = Optional.absent();
        private Optional<Duration> startupTime = Optional.absent();
        private Optional<String> nonSdkApiSignature = Optional.absent();

        Builder() {
        }

        @Override
        public LogLine.Builder type(LogLine.LogMessageType type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public LogLine.Builder timeStamp(Instant timeStamp) {
            if (timeStamp == null) {
                throw new NullPointerException("Null timeStamp");
            }
            this.timeStamp = timeStamp;
            return this;
        }

        @Override
        public LogLine.Builder severity(LogLine.LogSeverity severity) {
            if (severity == null) {
                throw new NullPointerException("Null severity");
            }
            this.severity = severity;
            return this;
        }

        @Override
        public LogLine.Builder tag(String tag) {
            if (tag == null) {
                throw new NullPointerException("Null tag");
            }
            this.tag = tag;
            return this;
        }

        @Override
        public LogLine.Builder processId(int processId) {
            this.processId = processId;
            return this;
        }

        @Override
        public LogLine.Builder lineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        @Override
        public LogLine.Builder message(String message) {
            if (message == null) {
                throw new NullPointerException("Null message");
            }
            this.message = message;
            return this;
        }

        @Override
        public LogLine.Builder fullLogLine(String fullLogLine) {
            if (fullLogLine == null) {
                throw new NullPointerException("Null fullLogLine");
            }
            this.fullLogLine = fullLogLine;
            return this;
        }

        @Override
        public LogLine.Builder sourceClass(String sourceClass) {
            if (sourceClass == null) {
                throw new NullPointerException("Null sourceClass");
            }
            this.sourceClass = Optional.of(sourceClass);
            return this;
        }

        @Override
        public LogLine.Builder sourceMethod(String sourceMethod) {
            if (sourceMethod == null) {
                throw new NullPointerException("Null sourceMethod");
            }
            this.sourceMethod = Optional.of(sourceMethod);
            return this;
        }

        @Override
        public LogLine.Builder sourceLine(String sourceLine) {
            if (sourceLine == null) {
                throw new NullPointerException("Null sourceLine");
            }
            this.sourceLine = Optional.of(sourceLine);
            return this;
        }

        @Override
        public LogLine.Builder causedBy(String causedBy) {
            if (causedBy == null) {
                throw new NullPointerException("Null causedBy");
            }
            this.causedBy = Optional.of(causedBy);
            return this;
        }

        @Override
        public LogLine.Builder packageName(String packageName) {
            if (packageName == null) {
                throw new NullPointerException("Null packageName");
            }
            this.packageName = Optional.of(packageName);
            return this;
        }

        @Override
        public LogLine.Builder targetProcessId(int targetProcessId) {
            this.targetProcessId = Optional.of(targetProcessId);
            return this;
        }

        @Override
        public LogLine.Builder startupTime(Duration startupTime) {
            if (startupTime == null) {
                throw new NullPointerException("Null startupTime");
            }
            this.startupTime = Optional.of(startupTime);
            return this;
        }

        @Override
        public LogLine.Builder nonSdkApiSignature(String nonSdkApiSignature) {
            if (nonSdkApiSignature == null) {
                throw new NullPointerException("Null nonSdkApiSignature");
            }
            this.nonSdkApiSignature = Optional.of(nonSdkApiSignature);
            return this;
        }

        @Override
        public LogLine build() {
            String missing = "";
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.timeStamp == null) {
                missing = missing + " timeStamp";
            }
            if (this.severity == null) {
                missing = missing + " severity";
            }
            if (this.tag == null) {
                missing = missing + " tag";
            }
            if (this.processId == null) {
                missing = missing + " processId";
            }
            if (this.lineNumber == null) {
                missing = missing + " lineNumber";
            }
            if (this.message == null) {
                missing = missing + " message";
            }
            if (this.fullLogLine == null) {
                missing = missing + " fullLogLine";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_LogLine(this.type, this.timeStamp, this.severity, this.tag, this.processId, this.lineNumber, this.message, this.fullLogLine, this.sourceClass, this.sourceMethod, this.sourceLine, this.causedBy, this.packageName, this.targetProcessId, this.startupTime, this.nonSdkApiSignature);
        }
    }
}

