/*
 * MIT License
 * Copyright (c) 2017 TeamViewer GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
*/
#include "client.h"

#include <stdio.h>
#include "sensor.h"
#include "userdata.h"

static void OnConnect(TVCMI_Client* client, void* userData, TVCMI_Error err)
{
	struct UserData* data = (struct UserData*) userData;
	CreateSensor(client, data);
}

static void OnProvisionClient(TVCMI_Client* client, void* userData, TVCMI_Error err)
{
	if (err == TVCMI_Error_Success || err == TVCMI_Error_AlreadyProvisioned)
	{
		struct UserData* data = (struct UserData*) userData;
		data->isProvisioned = 1;
	}
}

void Connect(TVCMI_Client* client)
{
	TVCMI_ConnectCallbackSet(client, &OnConnect);
	TVCMI_Connect(client);
}

void Provision(TVCMI_Client* client)
{
	TVCMI_ProvisionClientCallbackSet(client, OnProvisionClient);
	TVCMI_ProvisionClient(client);
}
