/*
 * MIT License
 * Copyright (c) 2017 TeamViewer GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
*/

#pragma once
#include "tvcmi_client.h"

#include "userdata.h"

/**
 * @brief CreateMetrics Start the metric registration
 */
void CreateMetrics(TVCMI_Client* client, struct UserData* userData);

/**
 * @brief OnPushMetricValues Will destroy the valuecontainer which was needed to create for the push.
 */
void OnPushMetricValues(TVCMI_Client* client, void* userData, const char* sensorId, TVCMI_ApiError err);

/**
 * @brief PushValues Will send the provided data to the api.
 */
void PushValues(struct UserData* data, const double tempValue, const int productivity, const char* currentProducedGoods);

/**
 * @brief OnCreateMetrics Will print the metricId's and will switch the flag for the main loop to start the updating.
 */
void OnCreateMetrics(TVCMI_Client* client, void* userData,
					 TVCMI_CreatedMetrics* createdMetrics,
					 TVCMI_ApiError err);
