/*
 * MIT License
 * Copyright (c) 2017 TeamViewer GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
*/

#include "sensor.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#if defined _WIN32 || defined _WIN64
#include "unistd_win.h"
#else
#include <unistd.h>
#endif

#include "userdata.h"
#include "metric.h"

void CreateSensor(TVCMI_Client* client, struct UserData* userData)
{
	TVCMI_CreateSensorCallbackSet(client, &OnCreateSensor);
	TVCMI_CreateSensor(client, userData->nameOfSensor);
}

void OnCreateSensor(TVCMI_Client* client, void* userData, const char* sensorName, const char* sensorId, TVCMI_ApiError err)
{
	struct UserData* data = (struct UserData*) userData;
	data->sensorId = strdup(sensorId);

	printf("Created SensorId is %s \n", sensorId);

	// Wait until the sensor is created, then create metrics.
	// WARNING! removing this delay will cause wrong behaviour.
	sleep(1);

	CreateMetrics(client, data);
}
